
function [] = excel_output_PMAnalyzer(exceloutput_inputcell)

subjects_readin                 = exceloutput_inputcell{1};
trials_readin                   = exceloutput_inputcell{2};
describe_subjects               = exceloutput_inputcell{3};
excel_directory                 = exceloutput_inputcell{4};
nr_PC_components                = exceloutput_inputcell{5};
EV_VAR                          = exceloutput_inputcell{6};
VariablesEigenvalues            = exceloutput_inputcell{7};
VariablesSelfdefined            = exceloutput_inputcell{8};
InfoVarsComputed                = exceloutput_inputcell{9};
includeVars                     = exceloutput_inputcell{10};



nr_subj_readin = length(subjects_readin);
nr_trials_readin = length(trials_readin);
nr_selfdefVars = 0; % enough for eigenvalues

PP_rSTD_TrialSubjPC        = VariablesEigenvalues.PP_rSTD_TrialSubjPC;
PP_rVAR_TrialSubjPC        = VariablesEigenvalues.PP_rVAR_TrialSubjPC;
PP_CUM_rSTD_TrialSubjPC    = VariablesEigenvalues.PP_CUM_rSTD_TrialSubjPC;
PP_CUM_rVAR_TrialSubjPC    = VariablesEigenvalues.PP_CUM_rVAR_TrialSubjPC;

PV_rSTD_TrialSubjPC        = VariablesEigenvalues.PV_rSTD_TrialSubjPC;
PV_rVAR_TrialSubjPC        = VariablesEigenvalues.PV_rVAR_TrialSubjPC;
PV_CUM_rSTD_TrialSubjPC    = VariablesEigenvalues.PV_CUM_rSTD_TrialSubjPC;
PV_CUM_rVAR_TrialSubjPC    = VariablesEigenvalues.PV_CUM_rVAR_TrialSubjPC;

PA_rSTD_TrialSubjPC        = VariablesEigenvalues.PA_rSTD_TrialSubjPC;
PA_rVAR_TrialSubjPC        = VariablesEigenvalues.PA_rVAR_TrialSubjPC;
PA_CUM_rSTD_TrialSubjPC    = VariablesEigenvalues.PA_CUM_rSTD_TrialSubjPC;
PA_CUM_rVAR_TrialSubjPC    = VariablesEigenvalues.PA_CUM_rVAR_TrialSubjPC;

PP_variables_TrialSubjPC = VariablesSelfdefined.PP_variables_TrialSubjPC;
PV_variables_TrialSubjPC = VariablesSelfdefined.PV_variables_TrialSubjPC;
PA_variables_TrialSubjPC = VariablesSelfdefined.PA_variables_TrialSubjPC;

        




% Initializing - preparing row and column names of tables for excel output
TrialSubjectNames = cell(nr_trials_readin*nr_subj_readin,1);
PC_Component_names = cell(1,nr_PC_components);

PP_names = cell(1,nr_PC_components);
PV_names = cell(1,nr_PC_components);
PA_names = cell(1,nr_PC_components);
for pc = 1:nr_PC_components
    PC_Component_names{1,pc} = ['PP', num2str(pc)];
    PC_Component_names{2,pc} = ['PV', num2str(pc)];
    PC_Component_names{3,pc} = ['PA', num2str(pc)];
    
    PP_names{1,pc} = ['PP', num2str(pc)];
    PV_names{1,pc} = ['PV', num2str(pc)];
    PA_names{1,pc} = ['PA', num2str(pc)];
end
ctrTrialSub = 0;
for trial=trials_readin
    for subj=subjects_readin
        ctrTrialSub = ctrTrialSub + 1;
        TrialSubjectNames{ctrTrialSub} = ['Trial ',num2str(trial), ' - Subject ', num2str(subj)];
    end
end


PC_list = cell(1,length(EV_VAR));
for pc = 1:length(EV_VAR)
    PC_list{1,pc} = ['PC', num2str(pc)];
end


%%  Specify TITLES of tables with variables
Title_EV_VAR = {'Total Variance'};
Title_rVAR_PP = {'Relative subject specific variance (PP) [%]'};
Title_rSTD_PP = {'Relative subject specific standard Deviation (PP) [%]'};
Title_CUM_rVAR_PP = {'Relative subject specific cumulative variance (PP) [%]'};
Title_CUM_rSTD_PP = {'Relative subject specific cumulative standard Deviation (PP) [%]'};

if includeVars   
    % Check that only variables with scalar value are used
    nr_selfdefVars = length(InfoVarsComputed);
    NonSkalarVars = [];
    for selfDefVar = 1:nr_selfdefVars
        for trial = trials_readin(1)
            for subj = subjects_readin(1)
                for pc = 1
                    VarChecked = PP_variables_TrialSubjPC(trial, subj, pc).(InfoVarsComputed(selfDefVar).VarName);
                    if ~isscalar(VarChecked)
                        NonSkalarVars = [NonSkalarVars, selfDefVar];
                    else
                    end
                end
            end
        end
    end
    
    if  ~isempty(NonSkalarVars)
           InfoVarsComputed(NonSkalarVars) = [];
           nr_selfdefVars = nr_selfdefVars-length(NonSkalarVars);
    end   
    TitlesAllSelfDef = cell(3,nr_selfdefVars);
    for selfDefVar = 1:nr_selfdefVars
        TitlesAllSelfDef{1,selfDefVar} = ['PP - ', InfoVarsComputed(selfDefVar).VarName, ' ', InfoVarsComputed(selfDefVar).VarUnit];
        TitlesAllSelfDef{2,selfDefVar} = ['PV - ', InfoVarsComputed(selfDefVar).VarName, ' ', InfoVarsComputed(selfDefVar).VarUnit];
        TitlesAllSelfDef{3,selfDefVar} = ['PA - ', InfoVarsComputed(selfDefVar).VarName, ' ', InfoVarsComputed(selfDefVar).VarUnit];
    end
end



%% Preallocation of arrays that later are written to tables

% Preallocate PP variables that are always written to excel
PC_array_rVAR_PP = zeros(nr_trials_readin*nr_subj_readin,nr_PC_components);
PC_array_rSTD_PP = zeros(nr_trials_readin*nr_subj_readin,nr_PC_components);

if includeVars  
    PC_arrays_allSelfdefVars = cell(3,nr_selfdefVars);
    for selfDefVar = 1:length(InfoVarsComputed)
        PC_arrays_allSelfdefVars{1,selfDefVar} = zeros(nr_trials_readin*nr_subj_readin,nr_PC_components);
        PC_arrays_allSelfdefVars{2,selfDefVar} = zeros(nr_trials_readin*nr_subj_readin,nr_PC_components);
        PC_arrays_allSelfdefVars{3,selfDefVar} = zeros(nr_trials_readin*nr_subj_readin,nr_PC_components);
    end
end



%% Extraction of variables to write into excel
for pc = 1:nr_PC_components
    ctrTrial = 0;
    for trial = trials_readin
        ctrTrial = ctrTrial + 1;
        ctrSubj = 0;
        for subj = subjects_readin
            ctrSubj = ctrSubj + 1;
            % PP vars - alway included
            PC_array_rVAR_PP((ctrTrial-1)*nr_subj_readin+ctrSubj, pc) = PP_rVAR_TrialSubjPC(trial, subj, pc);
            PC_array_rSTD_PP((ctrTrial-1)*nr_subj_readin+ctrSubj, pc) = PP_rSTD_TrialSubjPC(trial, subj, pc);
            PC_array_CUM_rVAR_PP((ctrTrial-1)*nr_subj_readin+ctrSubj, pc) = PP_CUM_rVAR_TrialSubjPC(trial, subj, pc);
            PC_array_CUM_rSTD_PP((ctrTrial-1)*nr_subj_readin+ctrSubj, pc) = PP_CUM_rSTD_TrialSubjPC(trial, subj, pc);

            if includeVars 
                    for selfDefVar = 1:length(InfoVarsComputed)
                        PC_arrays_allSelfdefVars{1,selfDefVar}((ctrTrial-1)*nr_subj_readin+ctrSubj, pc) = PP_variables_TrialSubjPC(trial, subj, pc).(InfoVarsComputed(selfDefVar).VarName);
                        PC_arrays_allSelfdefVars{2,selfDefVar}((ctrTrial-1)*nr_subj_readin+ctrSubj, pc) = PV_variables_TrialSubjPC(trial, subj, pc).(InfoVarsComputed(selfDefVar).VarName);
                        PC_arrays_allSelfdefVars{3,selfDefVar}((ctrTrial-1)*nr_subj_readin+ctrSubj, pc) = PA_variables_TrialSubjPC(trial, subj, pc).(InfoVarsComputed(selfDefVar).VarName);
                    end
            end
        end
    end
end



% PC_arrays_allSelfdefVars



%% Create Tables and titles for excel output
Table_EV_VAR = array2table(EV_VAR','VariableNames',{'TotalVar'}, 'RowNames', PC_list');
% PP tables - always included
Table_rVAR_PP = array2table(PC_array_rVAR_PP,'VariableNames',PP_names, 'RowNames', TrialSubjectNames);
Table_rSTD_PP = array2table(PC_array_rSTD_PP,'VariableNames',PP_names, 'RowNames', TrialSubjectNames);
Table_CUM_rVAR_PP = array2table(PC_array_CUM_rVAR_PP,'VariableNames',PP_names, 'RowNames', TrialSubjectNames);
Table_CUM_rSTD_PP = array2table(PC_array_CUM_rSTD_PP,'VariableNames',PP_names, 'RowNames', TrialSubjectNames);


if includeVars
    Tables_allSelfDefVars = cell(3, nr_selfdefVars);
    for vars = 1:nr_selfdefVars
        Tables_allSelfDefVars{1,vars} = array2table(PC_arrays_allSelfdefVars{1,vars},  'VariableNames',PC_Component_names(1,:), 'RowNames', TrialSubjectNames);
        Tables_allSelfDefVars{2,vars} = array2table(PC_arrays_allSelfdefVars{2,vars},  'VariableNames',PC_Component_names(2,:), 'RowNames', TrialSubjectNames);
        Tables_allSelfDefVars{3,vars} = array2table(PC_arrays_allSelfdefVars{3,vars},  'VariableNames',PC_Component_names(3,:), 'RowNames', TrialSubjectNames);
    end
end







filename = [describe_subjects,'.xlsx'];
excel_file_name = [excel_directory,filename]
A = exist(excel_file_name, 'file');
if A == 2
    delete(excel_file_name)
else
end



 
%% Determine excel cells to write tables in
Alphabet = ['A';'B';'C';'D';'E';'F';'G';'H';'I';'J';'K';'L';'M';'N';'O';'P';'Q';'R';'S';'T';'U';'V';'W';'X';'Y';'Z'];
excel_columns = [repmat(' ', 26,1), Alphabet];
for letter = 1:26
    excel_columns = [excel_columns;repmat(Alphabet(letter),26,1),Alphabet];
end

nr_Vars = max(nr_selfdefVars, 5); % Eigenvalue Variables are alway outputted
Startingpoints = cell(2,nr_Vars);
for var = 1:nr_Vars
    Startingpoints{1,var} = excel_columns(2+(var-1)*(nr_PC_components+2),:);
    Startingpoints{2,var} = excel_columns(2+(var-1)*(nr_PC_components+2)+floor(nr_PC_components/2),:);
    if 2+(var-1)*(nr_PC_components+2) <= 26
        Startingpoints{1,var}(:,1) = []; % Cut out "space"
    end
    if 2+(var-1)*(nr_PC_components+2)+floor(nr_PC_components/2) <= 26
        Startingpoints{2,var}(:,1) = []; % Cut out "space"
    end
end




%% Excel file is made - Not yet dynamic for Nr. of variables changes!

% Write EV - table to excel
fprintf('\n             writing eigenvalues (EV, PP_rSTD, PP_rVAR) to Excel spreadsheet')

writetable(Table_EV_VAR,excel_file_name,'Sheet','Eigenvalues','WriteRowNames',true,'Range',[Startingpoints{1,1},num2str(nr_trials_readin*nr_subj_readin+6)])
% xlswrite(excel_file_name,Title_EV_VAR,'Eigenvalues',[Startingpoints{2,1},num2str(nr_trials_readin*nr_subj_readin+6)])

% Writel PP eigenvalues to excel 
writetable(Table_rVAR_PP,excel_file_name,'Sheet','Eigenvalues','WriteRowNames',true,'Range',[Startingpoints{1,2},'3'])
writetable(Table_rSTD_PP,excel_file_name,'Sheet','Eigenvalues','WriteRowNames',true,'Range',[Startingpoints{1,3},'3'])
writetable(Table_CUM_rVAR_PP,excel_file_name,'Sheet','Eigenvalues','WriteRowNames',true,'Range',[Startingpoints{1,4},'3'])
writetable(Table_CUM_rSTD_PP,excel_file_name,'Sheet','Eigenvalues','WriteRowNames',true,'Range',[Startingpoints{1,5},'3'])

% Write titles of PP variables to excel
xlswrite(excel_file_name,Title_rVAR_PP,'Eigenvalues',[Startingpoints{2,2},'2'])
xlswrite(excel_file_name,Title_rSTD_PP,'Eigenvalues',[Startingpoints{2,3},'2'])
xlswrite(excel_file_name,Title_CUM_rVAR_PP,'Eigenvalues',[Startingpoints{2,4},'2'])
xlswrite(excel_file_name,Title_CUM_rSTD_PP,'Eigenvalues',[Startingpoints{2,5},'2'])



if includeVars
    for vars = 1:nr_selfdefVars
        fprintf('\n             writing table of variable %d (%s) to Excel spreadsheet', vars, InfoVarsComputed(vars).VarName)
        writetable(Tables_allSelfDefVars{1,vars},excel_file_name,'Sheet','PP variables','WriteRowNames',true,'Range',[Startingpoints{1,vars},'3'])
        writetable(Tables_allSelfDefVars{2,vars},excel_file_name,'Sheet','PV variables','WriteRowNames',true,'Range',[Startingpoints{1,vars},'3'])
        writetable(Tables_allSelfDefVars{3,vars},excel_file_name,'Sheet','PA variables','WriteRowNames',true,'Range',[Startingpoints{1,vars},'3'])
        
        xlswrite(excel_file_name,TitlesAllSelfDef(1,vars),'PP variables',[Startingpoints{2,vars},'2'])
        xlswrite(excel_file_name,TitlesAllSelfDef(2,vars),'PV variables',[Startingpoints{2,vars},'2'])
        xlswrite(excel_file_name,TitlesAllSelfDef(3,vars),'PA variables',[Startingpoints{2,vars},'2'])
    end
end



%% Check if spreadsheets are in named as needed
[EXstatus, allSheets, EXformat] = xlsfinfo(excel_file_name);

% Activate ActiveX escel and open Excel file.
objExcel = actxserver('Excel.Application');
objExcel.Workbooks.Open(excel_file_name);
for sh = 1:length(allSheets)
    if sum([strcmp(allSheets{sh}, 'Eigenvalues'), strcmp(allSheets{sh}, 'PP variables'), strcmp(allSheets{sh}, 'PV variables'), strcmp(allSheets{sh}, 'PA variables')]) ~= 1
       objExcel.ActiveWorkbook.Worksheets.Item(allSheets{sh}).Delete;
    end
end
% Save, close and clean up
objExcel.ActiveWorkbook.Save;
objExcel.ActiveWorkbook.Close;
objExcel.Quit;
objExcel.delete;


end




